In order to use the activeCollab API, first you will need to authenticate yourself to the system, which you can do using your API key. This key is available on the <{option}>API Subscriptions<{/option}> page of your activeCollab user profile:

<{image name="api-url-and-token.jpg"}>

When creating a request, the API key must be passed as a <{code}>auth_api_token<{/code}> GET variable. The sample request URL would then look like this:

<{code inline=false}>http://site.com/activecollab/api.php?path_info=info&auth_api_token=1-spUJiaAK5kQqU87OnB4nHZUuYWRlzjDP4cY5CxXN<{/code}>

<{sub slug='obtain-api-key'}>Obtain API Key Programmatically<{/sub}>

activeCollab 3 API no longer requires users to copy and paste their API keys in order to authenticate. Instead, they can provide their regular user credential and have application that uses API get API key in the background, and store it for further use.

To subscribe, application needs to send a POST request to activeCollab's api.php file, that has following variables:

1. <{code}>api_subscription[email]<{/code}> - Email address of a user who is authenticating
2. <{code}>api_subscription[password]<{/code}> - Users password
3. <{code}>api_subscription[client_name]<{/code}> - Name of the application that is requesting subscription
4. <{code}>api_subscription[client_vendor]<{/code}> - Name of the organization that developed the application that's subscribing

When successfully subscribed, system will return API key in plain text. For example, this request:

<{code inline=false}>curl --data "api_subscription[email]=user@company.com&api_subscription[password]=**********&api_subscription[client_name]=SubscriptionTest&api_subscription[client_vendor]=A51" http://site.com/activecollab/api.php<{/code}>

will return API key like this:

<{code inline=false}>API key: 1-rtYM2JqeuZHkAuHcN4MXyiqyd1PW3kJjEwVu7azp<{/code}>

If not, following error codes are throw:

* HTTP error 500 - Operation Failed. Multiple reasons are possible, and they are explained later on.
* HTTP error 403 - Forbidden. This response is thrown when there user is successfully authenticated, but they don't have permissions to use API (administrator disabled it in their system role)
* HTTP error 400 - Bad Request. Unknown error

System also returns following error codes as body of the response:

* <{code}>0<{/code}> - Unknown error
* <{code}>1<{/code}> - Client details not set
* <{code}>2<{/code}> - Unknown user
* <{code}>3<{/code}> - Invalid Password
* <{code}>4<{/code}> - Not allowed for given user and their system role

Example response with error code:

<{code inline=false}>Error Code: 3<{/code}>